/*
 * SAXTest.c
 *
 * main file for SAXTest
 *
 * This wizard-generated code is based on code adapted from the
 * stationery files distributed as part of the Palm OS SDK 4.0.
 *
 * Copyright (c) 1999-2000 Palm, Inc. or its subsidiaries.
 * All rights reserved.
 */
 
#include <PalmOS.h>
#include <PalmOSGlue.h>

#include "SAXTest.h"
#include "SAXTest_Rsc.h"

#include "SAXLib.h"

#include "VFSMgr.h"

/*********************************************************************
 * Entry Points
 *********************************************************************/

/*********************************************************************
 * Global variables
 *********************************************************************/
UInt16	g_libRef;


/*********************************************************************
 * Internal Constants
 *********************************************************************/

/* Define the minimum OS version we support */
#define ourMinVersion    sysMakeROMVersion(3,0,0,sysROMStageDevelopment,0)
#define kPalmOS20Version sysMakeROMVersion(2,0,0,sysROMStageDevelopment,0)

/*********************************************************************
 * Internal Functions
 *********************************************************************/

/*
 * FUNCTION: GetObjectPtr
 *
 * DESCRIPTION:
 *
 * This routine returns a pointer to an object in the current form.
 *
 * PARAMETERS:
 *
 * formId
 *     id of the form to display
 *
 * RETURNED:
 *     address of object as a void pointer
 */

static void * GetObjectPtr(UInt16 objectID)
{
	FormType * frmP;

	frmP = FrmGetActiveForm();
	return FrmGetObjectPtr(frmP, FrmGetObjectIndex(frmP, objectID));
}

/*
 * FUNCTION: MainFormInit
 *
 * DESCRIPTION: This routine initializes the MainForm form.
 *
 * PARAMETERS:
 *
 * frm
 *     pointer to the MainForm form.
 */

static void MainFormInit(FormType *frmP)
{
	UInt16 fieldIndex;

	fieldIndex = FrmGetObjectIndex(frmP, FilePathNameField);
	FrmSetFocus(frmP, fieldIndex);
	
	g_ParseStatus=NULL;
}

/*
 * FUNCTION: MainFormDoCommand
 *
 * DESCRIPTION: This routine performs the menu command specified.
 *
 * PARAMETERS:
 *
 * command
 *     menu item id
 */

static Boolean MainFormDoCommand(UInt16 command)
{
	Boolean handled = false;

	switch (command)
	{

	}

	return handled;
}

/*
 * FUNCTION: MainFormHandleEvent
 *
 * DESCRIPTION:
 *
 * This routine is the event handler for the "MainForm" of this 
 * application.
 *
 * PARAMETERS:
 *
 * eventP
 *     a pointer to an EventType structure
 *
 * RETURNED:
 *     true if the event was handled and should not be passed to
 *     FrmHandleEvent
 */

static Boolean MainFormHandleEvent(EventType * eventP)
{
	Boolean handled = false;
	FormType * frmP;
	frmP = FrmGetActiveForm();

	switch (eventP->eType) 
	{
		case menuEvent:
			return MainFormDoCommand(eventP->data.menu.itemID);

		case frmOpenEvent:
			FrmDrawForm(frmP);
			MainFormInit(frmP);
			handled = true;
			break;
            
        case frmUpdateEvent:
			/* 
			 * To do any custom drawing here, first call
			 * FrmDrawForm(), then do your drawing, and
			 * then set handled to true. 
			 */
			break;
			
		case ctlSelectEvent:
		{
			if ((eventP->data.ctlSelect.controlID==MainLaunchSAXButton)||
				(eventP->data.ctlSelect.controlID==MainResumeSAXButton))
			{
				Err err;
				UInt32 	clientContext;
				err=SysLibFind(SAXLibName,&g_libRef);	
				if (err==sysErrLibNotFound)
				{
					err=SysLibLoad(sysFileTLibrary,SAXLibCreatorID,&g_libRef);
				}
				if (err==errNone)
				{
					err=SAXLibOpen(g_libRef,&clientContext);
					if (err==errNone)
					{
						// Set "File Provider"
						FileProvider fileProvider;
						fileProvider.OpenFile=FP_OpenFile;
						fileProvider.GetFileBlockSize=FP_GetFileBlockSize;
						fileProvider.ReadFile=FP_ReadFile;
						fileProvider.CloseFile=FP_CloseFile;
						fileProvider.SeekFile=FP_SeekFile;
						fileProvider.GetFileSize=FP_GetFileSize;
						SAXLibSetFileProvider(g_libRef,clientContext,&fileProvider);
						
						// Set "Content handler"
						ContentHandler contentHandler;
						MemSet(&contentHandler,sizeof(ContentHandler),0x00);
						contentHandler.StartElement=CH_StartElement;
						contentHandler.EndElement=CH_EndElement;
						contentHandler.Characters=CH_Characters;
						contentHandler.SetDocumentLocator=CH_SetDocumentLocator;
						contentHandler.EndDocument=CH_EndDocument;
						SAXLibSetContentHandler(g_libRef,clientContext,&contentHandler);
						
						// Get file name
						FieldPtr pFld=(FieldPtr)FrmGetObjectPtr(frmP,FrmGetObjectIndex(frmP,FilePathNameField));
						Char *pFileName=(Char*)FldGetTextPtr(pFld);
						// Enumerate volumes and get the first one's volume reference number (fix for multi-volume devices)
						UInt16 volRefNum;
						UInt32 volIterator=vfsIteratorStart;
						Err err=VFSVolumeEnumerate(&volRefNum,&volIterator); 
					   	if (err!=errNone) break;
						Char pVolStr[maxStrIToALen];
						StrIToA(pVolStr,volRefNum);
						// Construct full volume-file name in format "volRefNum"+"filePathName"
						// example "1/PALM/books.xml"
						Char *pFullName=(Char*)MemPtrNew(StrLen(pVolStr)+StrLen(pFileName)+1);
						StrCopy(pFullName,pVolStr);
						StrCat(pFullName,pFileName);
						
						if (eventP->data.ctlSelect.controlID==MainLaunchSAXButton)
						{
							err=SAXLibParse(g_libRef,clientContext,pFullName,encodingCP1250);
						}
						else if (g_ParseStatus)
						{
							err=SAXLibParseResume(g_libRef,clientContext,pFullName,encodingCP1250,g_ParseStatus);
							MemHandleFree(g_ParseStatus);
							g_ParseStatus=NULL;
						}
						
						MemPtrFree(pFullName);
						
						err=SAXLibClose(g_libRef,clientContext);
						if (err==errNone) SysLibRemove(g_libRef);
					}
				}
			}

			break;
		}
	}
    
	return handled;
}

/*
 * FUNCTION: AppHandleEvent
 *
 * DESCRIPTION: 
 *
 * This routine loads form resources and set the event handler for
 * the form loaded.
 *
 * PARAMETERS:
 *
 * event
 *     a pointer to an EventType structure
 *
 * RETURNED:
 *     true if the event was handled and should not be passed
 *     to a higher level handler.
 */

static Boolean AppHandleEvent(EventType * eventP)
{
	UInt16 formId;
	FormType * frmP;

	if (eventP->eType == frmLoadEvent)
	{
		/* Load the form resource. */
		formId = eventP->data.frmLoad.formID;
		frmP = FrmInitForm(formId);
		FrmSetActiveForm(frmP);

		/* 
		 * Set the event handler for the form.  The handler of the
		 * currently active form is called by FrmHandleEvent each
		 * time is receives an event. 
		 */
		switch (formId)
		{
			case MainForm:
				FrmSetEventHandler(frmP, MainFormHandleEvent);
				break;

		}
		return true;
	}

	return false;
}

/*
 * FUNCTION: AppEventLoop
 *
 * DESCRIPTION: This routine is the event loop for the application.
 */

static void AppEventLoop(void)
{
	UInt16 error;
	EventType event;

	do 
	{
		/* change timeout if you need periodic nilEvents */
		EvtGetEvent(&event, evtWaitForever);

		if (! SysHandleEvent(&event))
		{
			if (! MenuHandleEvent(0, &event, &error))
			{
				if (! AppHandleEvent(&event))
				{
					FrmDispatchEvent(&event);
				}
			}
		}
	} while (event.eType != appStopEvent);
}

/*
 * FUNCTION: AppStart
 *
 * DESCRIPTION:  Get the current application's preferences.
 *
 * RETURNED:
 *     errNone - if nothing went wrong
 */

static Err AppStart(void)
{

	return errNone;
}

/*
 * FUNCTION: AppStop
 *
 * DESCRIPTION: Save the current state of the application.
 */

static void AppStop(void)
{
        
	/* Close all the open forms. */
	FrmCloseAllForms();
	
	if (g_ParseStatus)
	{
		MemPtrFree(g_ParseStatus);
		g_ParseStatus=NULL;
	}
}

/*
 * FUNCTION: RomVersionCompatible
 *
 * DESCRIPTION: 
 *
 * This routine checks that a ROM version is meet your minimum 
 * requirement.
 *
 * PARAMETERS:
 *
 * requiredVersion
 *     minimum rom version required
 *     (see sysFtrNumROMVersion in SystemMgr.h for format)
 *
 * launchFlags
 *     flags that indicate if the application UI is initialized
 *     These flags are one of the parameters to your app's PilotMain
 *
 * RETURNED:
 *     error code or zero if ROM version is compatible
 */

static Err RomVersionCompatible(UInt32 requiredVersion, UInt16 launchFlags)
{
	UInt32 romVersion;

	/* See if we're on in minimum required version of the ROM or later. */
	FtrGet(sysFtrCreator, sysFtrNumROMVersion, &romVersion);
	if (romVersion < requiredVersion)
	{
		if ((launchFlags & 
			(sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp)) ==
			(sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp))
		{
			FrmAlert (RomIncompatibleAlert);

			/* Palm OS versions before 2.0 will continuously relaunch this
			 * app unless we switch to another safe one. */
			if (romVersion < kPalmOS20Version)
			{
				AppLaunchWithCommand(
					sysFileCDefaultApp, 
					sysAppLaunchCmdNormalLaunch, NULL);
			}
		}

		return sysErrRomIncompatible;
	}

	return errNone;
}

/*
 * FUNCTION: PilotMain
 *
 * DESCRIPTION: This is the main entry point for the application.
 * 
 * PARAMETERS:
 *
 * cmd
 *     word value specifying the launch code. 
 *
 * cmdPB
 *     pointer to a structure that is associated with the launch code
 *
 * launchFlags
 *     word value providing extra information about the launch.
 *
 * RETURNED:
 *     Result of launch, errNone if all went OK
 */

UInt32 PilotMain(UInt16 cmd, MemPtr cmdPBP, UInt16 launchFlags)
{
	Err error;

	error = RomVersionCompatible (ourMinVersion, launchFlags);
	if (error) return (error);

	switch (cmd)
	{
		case sysAppLaunchCmdNormalLaunch:
			error = AppStart();
			if (error) 
				return error;

			/* 
			 * start application by opening the main form
			 * and then entering the main event loop 
			 */
			FrmGotoForm(MainForm);
			AppEventLoop();

			AppStop();
			break;
	}

	return errNone;
}
